#include <pic.h>		              // Inclusion du prototype du PIC 16F
#include  <htc.h>
#include <pic16f1827.h>
#include  <math.h>




/*                                 DFINITIONS DES CONSTANTES                                */
/*                                 **************************                                */
#define	_XTAL_FREQ 4000000              // This definition is required to calibrate __delay_us() and __delay_ms()

__CONFIG(FOSC_INTOSC & WDTE_OFF & MCLRE_ON & CP_OFF & CPD_OFF & BOREN_OFF );  //Internal clock,WDT disabled,MCLR/VPP pin function is MCLR,Program memory code protection is disabled,Data memory code protection is disabled,Brown-out Reset disabled
__CONFIG(WRT_OFF & PLLEN_ON & LVP_OFF);                                       //Write protection off,4x PLL enabled,High-voltage on MCLR/VPP must be used for programming


#define dev_on_1 0xEB
#define dev_on_2 0xEF
#define dev_on_3 0xF1
#define dev_on_4 0xF5
#define dev_on_5 0xF7
#define dev_on_6 0xF3
#define dev_on_7 0xFD
#define dev_on_8 0x65

#define dev_off_1 0x07
#define dev_off_2 0x25
#define dev_off_3 0x23
#define dev_off_4 0x13
#define dev_off_5 0x15
#define dev_off_6 0x17
#define dev_off_7 0x19
#define dev_off_8 0x09

#define all_off   0xA5
#define all_on    0xAD

#define dim_up 0x31
#define dim_down 0x27

#define Inhibit_1 RA3
#define Inhibit_2 RB5
#define Inhibit_3 RB4

#define A1  RA0
#define B1  RA1
#define C1  RA2

#define A2  RA4
#define B2  RA6
#define C2  RA7

#define A3  RB1
#define B3  RB2
#define C3  RB3

#define Button_Delay 200		//Delay qui simule le debouncing des touches


/*                              DCLARATION DES VARIABLES GLOBALES                           */
/*                              **********************************                           */

bit Bit_pulse                   = 0;
bit Flag_1_Sec                  = 0;
bit Flag_1_Ms                   = 0;
bit false_pulse_detect_bit      = 0;
bit sony_protocol_detect_bit    = 0;

unsigned
unsigned char pulse_count       = 0;
unsigned char IR_flag  = 0;
unsigned int Counter_1_sec      = 1000;        //1000 x 1ms = 1 seconde
unsigned int IR_code            = 0;
unsigned int Compteur_1         = 0;
unsigned int Pulse_1            = 0;
unsigned int Pulse_2            = 0;
unsigned int Pulse              = 0;
unsigned int IR_Code_count      = 0;
unsigned int IR_flag_count      = 0;

unsigned int pulse1_widht      = 0;
unsigned int pulse2_widht      = 0;
unsigned int pulse3_widht      = 0;
unsigned int pulse4_widht      = 0;
unsigned int pulse5_widht      = 0;
unsigned int pulse6_widht      = 0;
unsigned int pulse7_widht      = 0;
unsigned int pulse8_widht      = 0;
unsigned int pulse9_widht      = 0;
unsigned int pulse10_widht     = 0;
unsigned int pulse11_widht     = 0;
unsigned int pulse12_widht     = 0;



/*                      DCLARATION DES PROTOTYPES DES FONCTIONS INTERNES                    */
/*                      *************************************************                    */

void _delay(unsigned long cycles);


void Init_chip(void);
void Read_IR_Signal(void);
void Timer_1_Init(void);
void X10_control(void);
void pulse_widht_listing(void);
void put_sony_pulse_together(void);
void Macro_delay (void);
/*                               ENTRE DU PROGRAMME PRINCIPAL                               */
/*                               *****************************                               */

void main( )

{                                           //Dbut du programme principale

    Init_chip();
    Timer_1_Init();                  		 	//Active Timer 1
    
    while(1)

		{
		
			
			if (IR_flag==1)                   	// Niveau bas dtect sur la PIN RB0 (Capteur infrarouge inverse le signal

			{
			
           	 IR_flag = 0;						//Remet IR_flag  Zro
			 IR_code = 0;						//Remet IR_code  Zro
		     Read_IR_Signal();					//Dcode le signal Sony

			 GIE = 1;							//Ractive les interruptions globale

             if (sony_protocol_detect_bit == 1) //Si sony protocol est dtect
		     {
			  X10_control();				    //Controle X10
             }

             INTE = 1;  					   //Interrupt on RBO ractiv
						
			} 

			
			 	
		}

}												//Fin du programme principale



void Read_IR_Signal(void)

{ 
    sony_protocol_detect_bit = 0;
    Pulse_1 = 0;
    Compteur_1 = 0;
    Pulse = 0;
    pulse_count = 0;

    TMR1ON = 0;                                                     //Ferme timer1 et remet a zro
	TMR1L = 0;											            //Timer 1 est remis  zro
	TMR1H = 0;
	TMR1ON = 1;

	while(RB0==0)              			 	                        //Check pour un pulse de 2400 us qui indique une trame Sony
	{
     //Compteur 1 tourne
    }
	    TMR1ON = 0;
		Compteur_1 = (TMR1H<<8)| TMR1L;                            //Determiner la longueur du pulse de START 
        TMR1L = 0;
	    TMR1H = 0;
		TMR1ON = 1;
		
		while(RB0==1 && Pulse_1<1000)              			        //Compte tant que RB0 est haut et que le Pulse ne dpasse pas 1000 us
		{
	     Pulse_1 = (TMR1H<<8)| TMR1L;					        	//Va chercher la valeur du Timer 1 16 Bits pour savoir la longueur du pulse 1
		}
		
		TMR1ON = 0;
		Pulse_1 = (TMR1H<<8)| TMR1L;                                //Determiner la longueur du pulse de START 
        
		

		if(Compteur_1>2300 & Compteur_1<2500 & Pulse_1 < 650)       //Est-ce que le pulse est entre 2300 us et 2500 us pour indiquer le protocol Sony?
		{                                                           //Dbut du protocol Sony dtect
		              
         	int a;
			for (a = 0 ; a < 12 ; a++)   				            //Rpte 12 fois pour dterminer les 12 Bits
            {														//Dbut de la boucle For = 1er bit recu
								                
	            TMR1L = 0;
	            TMR1H = 0;
				TMR1ON = 1;	
				
				while(RB0==0)              			               //Compte tant que RB0 est bas (Dtecteur IR actif bas)
				{
	             //Le timer 1 roule pour savoir la longueur du pulse 1
				}
											
				while(RB0==1 && Pulse<2000)             	       //600 uS (gap entre les bits du protocol SONY) Si le dtecteur revient actif haut il faut sortir
				{
	             Pulse = (TMR1H<<8)| TMR1L;                        //Va chercher la valeur du Timer 1 16 Bits pour savoir la longueur du pulse 2
				}
	            
				TMR1ON = 0;	
	            Pulse = (TMR1H<<8)| TMR1L;              
				        
                pulse_count ++;
				pulse_widht_listing();
 
			}
                                                   //Fin de la boucle For = 12e bit recu
        put_sony_pulse_together();                                  
	    IR_Code_count ++;


        }
											         	         

}																   //Fin du Protocol Sony dtect
											         	
void put_sony_pulse_together(void)

{

 pulse_count = 0;
 false_pulse_detect_bit = 0;

 int a;

 for (a = 0 ; a < 12 ; a++)

 {

   pulse_count ++;

   switch(pulse_count)

   {

   case 1:
   Pulse = pulse1_widht;
   break;

   case 2:
   Pulse = pulse2_widht;
   break;


   case 3:
   Pulse = pulse3_widht;
   break;

   case 4:
   Pulse = pulse4_widht;
   break;

   case 5:
   Pulse = pulse5_widht;
   break;


   case 6:
   Pulse = pulse6_widht;
   break;

   case 7:
   Pulse = pulse7_widht;
   break;

   case 8:
   Pulse = pulse8_widht;
   break;

   case 9:
   Pulse = pulse9_widht;
   break;

   case 10:
   Pulse = pulse10_widht;
   break;

   case 11:
   Pulse = pulse11_widht;
   break;

   case 12:
   Pulse = 1000;   //Le premier bit LSB du protocol est forc  zro pout viter un erreur car ir dtecteur actif haut
   break;


   }            //Fin switch


	if((Pulse >= 1000)  && ( Pulse  <= 1200 ))      //Si le Pulse 1 et le Pulse 2 ensemble est entre 1100 us et 1300 us le BIT est 0
	{
 	 Bit_pulse = 0;
	}
       
	if((Pulse >= 1600)  && ( Pulse  <= 1800 ))      //Si le Pulse 1 et le Pulse 2 ensemble est entre 1700 us et 1800 us le BIT est 1
    {
     Bit_pulse = 1;
    }
					
	if((Pulse  < 1000) ||  ( Pulse >  1800 ))     	//Si le Pulse 1 et le Pulse 2 ensemble sont plus petit que 1100 us ou plus grand que 1900 us le pulse est null			
	{
	 false_pulse_detect_bit = 1;
	 a = 12;                                         //Skip la dtection des autres bits car un mauvais bit a t dtect
	 IR_code = 255;
    }

	if(false_pulse_detect_bit == 0)
	{
	 IR_code = (IR_code) + (Bit_pulse<<(11-a));          //Place les bits en ordre (le protocol Sony envoie le LSB en premier)
	}



 }      //Fin boucle for

    if(false_pulse_detect_bit == 0)
    {
	 IR_code = IR_code >> 4;	                         //Ramne sur 12 Bits
     sony_protocol_detect_bit = 1;
 	}
				               
}       //Fin fonction put_sony_together

 

void pulse_widht_listing(void)
{
switch(pulse_count)

{
case 1:
pulse1_widht = Pulse;
break;

case 2:
pulse2_widht = Pulse;
break;

case 3:
pulse3_widht = Pulse;
break;

case 4:
pulse4_widht = Pulse;
break;

case 5:
pulse5_widht = Pulse;
break;

case 6:
pulse6_widht = Pulse;

break;

case 7:
pulse7_widht = Pulse;

break;

case 8:
pulse8_widht = Pulse;
break;

case 9:
pulse9_widht = Pulse;
break;

case 10:
pulse10_widht = Pulse;
break;

case 11:
pulse11_widht = Pulse;
break;

case 12:
pulse12_widht = Pulse;
break;
}

}

void X10_control(void)

{

	switch (IR_code)

	{
	
    case dev_on_1:
	C1 = 1;
	B1 = 0;
	A1 = 0;
    Inhibit_1 = 0;
    __delay_ms(Button_Delay);
	Inhibit_1 = 1;
	break;
	
	case dev_on_2:
	C1 = 1;
	B1 = 0;
	A1 = 1;
    Inhibit_1 = 0;
    __delay_ms(Button_Delay);
	Inhibit_1 = 1;
	break;
	
	case dev_on_4:
	C1 = 0;
	B1 = 1;
	A1 = 1;
    Inhibit_1 = 0;
    __delay_ms(Button_Delay);
	Inhibit_1 = 1;
	break;
	
	case dev_on_5:
	C1 = 0;
	B1 = 1;
	A1 = 0;
    Inhibit_1 = 0;
    __delay_ms(Button_Delay);
	Inhibit_1 = 1;
	break;
	
	case dev_on_7:
	C1 = 0;
	B1 = 0;
	A1 = 1;
    Inhibit_1 = 0;
    __delay_ms(Button_Delay);
	Inhibit_1 = 1;
	break;
	
	case dev_on_8:
	C1 = 0;
	B1 = 0;
	A1 = 0;
    Inhibit_1 = 0;
    __delay_ms(Button_Delay);
	Inhibit_1 = 1;
	break;
	
	//2ieme 4051
	
	case dev_off_2:
	C2 = 1;
	B2 = 0;
	A2 = 0;
    Inhibit_2 = 0;
    __delay_ms(Button_Delay);
	Inhibit_2 = 1;
	break;
	
	case dev_off_3:
	C2 = 1;
	B2 = 0;
	A2 = 1;
    Inhibit_2 = 0;
     __delay_ms(Button_Delay);
	Inhibit_2 = 1;
	break;
	
	case dev_off_5:
	C2 = 0;
	B2 = 1;
	A2 = 1;
    Inhibit_2 = 0;
    __delay_ms(Button_Delay);
	Inhibit_2 = 1;
	break;
	
	case dev_off_6:
	C2 = 0;
	B2 = 1;
	A2 = 0;
    Inhibit_2 = 0;
    __delay_ms(Button_Delay);
	Inhibit_2 = 1;
	break;
	
	case dev_off_8:
	C2 = 0;
	B2 = 0;
	A2 = 1;
    Inhibit_2 = 0;
    __delay_ms(Button_Delay);
	Inhibit_2 = 1;
	break;
	
	case dim_down:  
	C2 = 0;
	B2 = 0;
	A2 = 0;
    Inhibit_2 = 0;
    __delay_ms(Button_Delay);
	Inhibit_2 = 1;
	break;
	
	
	
	//3ieme 4051
	
	case dev_on_3:
	C3 = 1;
	B3 = 0;
	A3 = 1;
    Inhibit_3 = 0;
    __delay_ms(Button_Delay);
	Inhibit_3 = 1;
	break;
	
	case dev_on_6:
	C3 = 0;
	B3 = 1;
	A3 = 0;
    Inhibit_3 = 0;
    __delay_ms(Button_Delay);
	Inhibit_3 = 1;
	break;
	
	case dim_up:
	C3 = 0;
	B3 = 0;
	A3 = 0;
    Inhibit_3 = 0;
    __delay_ms(Button_Delay);
	Inhibit_3 = 1;
	break;
	
	case dev_off_1:
	C3 = 1;
	B3 = 0;
	A3 = 0;
    Inhibit_3 = 0;
    __delay_ms(Button_Delay);
	Inhibit_3 = 1;
	break;
	
	case dev_off_4:
	C3 = 0;
	B3 = 1;
	A3 = 1;
    Inhibit_3 = 0;
    __delay_ms(Button_Delay);
	Inhibit_3 = 1;
	break;
	
	case dev_off_7:  
	C3 = 0;
	B3 = 0;
	A3 = 1;
    Inhibit_3 = 0;
    __delay_ms(Button_Delay);
	Inhibit_3 = 1;
	break;


    case all_off:   //Ferme tout les lumire de 1  8
	
        C3 = 1;     //Device 1 off
	B3 = 0;
	A3 = 0;
        Inhibit_3 = 0;
        __delay_ms(Button_Delay);
	Inhibit_3 = 1;
        Macro_delay();
    
        C2 = 1;    //Device 2 off
	B2 = 0;
	A2 = 0;
        Inhibit_2 = 0;
        __delay_ms(Button_Delay);
	Inhibit_2 = 1;
        Macro_delay();
    
        C2 = 1;  //Device 3 off
	B2 = 0;
	A2 = 1;
        Inhibit_2 = 0;
        __delay_ms(Button_Delay);
	Inhibit_2 = 1;
        Macro_delay();

        C3 = 0;  //Device 4 off
	B3 = 1;
	A3 = 1;
        Inhibit_3 = 0;
        __delay_ms(Button_Delay);
	Inhibit_3 = 1;
        Macro_delay();

        C2 = 0;  //Device 5 off
	B2 = 1;
	A2 = 1;
        Inhibit_2 = 0;
        __delay_ms(Button_Delay);
	Inhibit_2 = 1;
        Macro_delay();

        C2 = 0;  //Device 6 off
	B2 = 1;
	A2 = 0;
        Inhibit_2 = 0;
        __delay_ms(Button_Delay);
	Inhibit_2 = 1;
        Macro_delay();

        C3 = 0;  //Device 7 off
	B3 = 0;
	A3 = 1;
        Inhibit_3 = 0;
        __delay_ms(Button_Delay);
	Inhibit_3 = 1;
        Macro_delay();

        C2 = 0;  //Device 8 off
	B2 = 0;
	A2 = 1;
        Inhibit_2 = 0;
        __delay_ms(Button_Delay);
	Inhibit_2 = 1;

	break;
	
	case all_on:   //Ouvre tout les lumire de 1  8
	C1 = 1;  //Device 1 On
        B1 = 0;
        A1 = 0;
        Inhibit_1 = 0;
        __delay_ms(Button_Delay);
        Inhibit_1 = 1;

        Macro_delay();

        C1 = 1; //Device 2 On
        B1 = 0;
        A1 = 1;
        Inhibit_1 = 0;
        __delay_ms(Button_Delay);
        Inhibit_1 = 1;

        Macro_delay();

        C3 = 1; //Device 3 On
        B3 = 0;
        A3 = 1;
        Inhibit_3 = 0;
        __delay_ms(Button_Delay);
        Inhibit_3 = 1;

        Macro_delay();

        C1 = 0;//Device 4 On
        B1 = 1;
        A1 = 1;
        Inhibit_1 = 0;
        __delay_ms(Button_Delay);
        Inhibit_1 = 1;

        Macro_delay();

        C1 = 0;//Device 5 On
        B1 = 1;
        A1 = 0;
        Inhibit_1 = 0;
        __delay_ms(Button_Delay);
        Inhibit_1 = 1;

        Macro_delay();

        C3 = 0;//Device 6 On
        B3 = 1;
        A3 = 0;
        Inhibit_3 = 0;
        __delay_ms(Button_Delay);
        Inhibit_3 = 1;

        Macro_delay();

        C1 = 0;//Device 7 On
        B1 = 0;
        A1 = 1;
        Inhibit_1 = 0;
        __delay_ms(Button_Delay);
        Inhibit_1 = 1;

        Macro_delay();

        C1 = 0;//Device 8 On
        B1 = 0;
        A1 = 0;
        Inhibit_1 = 0;
        __delay_ms(Button_Delay);
        Inhibit_1 = 1;


	break;
        
	}

	
	
   

}
														//Fin de la fonction Read_IR_Signal

void Timer_1_Init (void)

 {

 T1CON = 0b00001101;          //Enables Timer1, Internal clock (FOSC/4) ,1:1 Prescale value 1uS
         //--00----           T1CKPS1:T1CKPS0: Timer1 Input Clock Prescale Select bits
	     //----1---   	      T1OSCEN: Timer1 Oscillator Enable Control bit
	     //-----1--    		  T1SYNC: Timer1 External Clock Input Synchronization Control bit
	     //------0-  	      TMR1CS: Timer1 Clock Source Select bit
	     //-------1   		  TMR1ON: Timer1 On bit
T1GCON = 0b0000000;	    

 __delay_ms(1);               //Attend que l'oscillateur se stabilise
 
 }

void Macro_delay (void) //Dlais 800 ms entre les transmission pour tout fermer

 {
    __delay_ms(100);
    __delay_ms(100);
    __delay_ms(100);
    __delay_ms(100);
    __delay_ms(100);
    __delay_ms(100);
    __delay_ms(100);
    __delay_ms(100);
}

void interrupt routine (void)

{

   if(INTF == 1)                //Interruption externe sur RB0 actif bas
   {
    GIE = 0;                    //Dsactive toute interruption
	INTE = 0;                   //Dsactive Interrupttion externe sur RBO temporairement
    INTF = 0;   				// Clear Flag RB0
    IR_flag = 1;
	IR_flag_count ++;
   }
   
  
}


void Init_chip (void)

{

OSCCON = 0b01101010;  //OSCILLATOR CONTROL REGISTER
         //0-------   Software PLL Enable bit
	     //-1101---	  Internal Oscillator Frequency Select bits (4MHz)
	     //------10   System Clock Select bits 

ANSELA = 0; 	         //Input mode I/O pin to digital
PORTA = 0;				 //Tout est  zro en partant
TRISA = 0b00000000;	     // Tous les bits en sortie
WPUA =  0b00000000;		 //WEAK PULL-UP Disabled on port A

ANSELB = 0;	           	 //Input mode I/O pin to digital
PORTB = 0;
TRISB = 0b00000001;	     //Port B en sortie sauf RBO pour Intterupt
WPUB =  0b11111111;		 //WEAK PULL-UP Enabled on port B

Inhibit_1 = 1;
Inhibit_2 = 1;
Inhibit_3 = 1;


OPTION_REG = 0b00000000;  //TMR0  prescaler/WDT  postscaler 
             //0-------   RBPU: PORTB Pull-up Enable bit
	         //-0------	  INTEDG: Interrupt Edge Select bit
	         //--0-----   T0CS: TMR0 Clock Source Select bit
	         //---0----   T0SE: TMR0 Source Edge Select bit
	         //----0---   PSA: Prescaler Assignment bit
	         //-----000   PS2:PS0: Prescaler Rate Select bits    

INTCON = 0b11010000;  //Register is a readable and writable register, which contains various enable and flag bits
         //1-------   GIE: Global Interrupt Enable bit 
	     //-1------	  PEIE: Peripheral Interrupt Enable bit
	     //--0-----   T0IE: TMR0 Overflow Interrupt Enable bit
	     //---1----   INTE: RB0/INT External Interrupt Enable bit
	     //----0---   RBIE: RB Port Change Interrupt Enable bit 
	     //-----0--   T0IF: TMR0 Overflow Interrupt Flag bit
	     //------0-   INTF: RB0/INT External Interrupt Flag bit
	     //-------0   RBIF: RB Port Change Interrupt Flag bit 

PIE1 = 0b00000000;   //The PIE1 register contains the individual enable bits for the peripheral interrupts.
       //0-------    PSPIE(1): Parallel Slave Port Read/Write Interrupt Enable bit
	   //-0------	 ADIE:     A/D Converter Interrupt Enable bit
	   //--0-----    RCIE:     USART Receive Interrupt Enable bit
	   //---0----    TXIE:     USART Transmit Interrupt Enable bit
	   //----0---    SSPIE:    Synchronous Serial Port Interrupt Enable bit
	   //-----0--    CCP1IE:   CCP1 Interrupt Enable bit
	   //------0-    TMR2IE:   TMR2 to PR2 Match Interrupt Enable bit
	   //-------0    TMR1IE:   TMR1 Overflow Interrupt Enable bit
	   
	   
PIE2 = 0b00000000;   //Individual enable bits for the  CCP2  peripheral  interrupt
       //-0------	  Reserved Always maintain this bit clear
	   //---0----     EEPROM Write Operation Interrupt Enable
	   //----0---     BCLIE:  Bus Collision Interrupt Enable
	   //-------0     CCP2IE: CCP2 Interrupt Enable bit
	   	   
PIR1 = 0b00000000;   //Individual flag bits for the peripheral interrupts.
       //0-------    PSPIF:  Parallel Slave Port Read/Write Interrupt Flag bit
	   //-0------	 ADIF:   A/D Converter Interrupt Flag bit
	   //--0-----    RCIF:   USART Receive Interrupt Flag bit
	   //---0----    TXIF:   USART Transmit Interrupt Flag bit
	   //----0---    SSPIF:  Synchronous Serial Port (SSP) Interrupt Flag
	   //-----0--    CCP1IF: CCP1 Interrupt Flag bit
	   //------0-    TMR2IF: TMR2 to PR2 Match Interrupt Flag bit
	   //-------0    TMR1IF: TMR1 Overflow Interrupt Flag bit


}